/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 20.10)
 *
 *  Copyright Steve Summit, 1995
 *  Ten kod moe by dowolnie uywany lub modyfikowany, bd wdziczny 
 *  za podanie rda. Nie daj jednak adnej gwarancji jego dziaania, 
 *  ani nie przyjmuj adnej odpowiedzialnoci za skutki jego 
 *  wykorzystania.
 *
 *  Uyj #define MAIN, aby skompilowa wersj testow, ktra wczytuje 
 *  wiersze postaci:
 *
 *	n b
 *
 *  gdzie n to liczba (w zapisie dziesitnym) a b to podstawa systemu, 
 *  na jaki naley j przeksztaci.
 */

#include <stdio.h>
#include <limits.h>	/* aby obliczy rozmiar retbuf[] */

char *
baseconv(unsigned int num, int base)
{
	static char retbuf[33];
	char *p;

	if(base < 2 || base > 16)
		return NULL;

	p = &retbuf[sizeof(retbuf)-1];
	*p = '\0';

	do {
		*--p = "0123456789abcdef"[num % base];
		num /= base;
	} while(num != 0);

	return p;
}

#ifdef MAIN

#include <stdlib.h>

#ifdef __STDC__
extern int getline(FILE *, char *, int);
extern int makeargv(char *, char *[], int);
#endif

main()
{
char line[100];
char *av[3];
while(getline(stdin, line, (int)sizeof(line)) != EOF)
	{
	if(makeargv(line, av, (int)(sizeof(av)/sizeof(*av))) != 2)
		continue;

	printf("%s\n", baseconv(atoi(av[0]), atoi(av[1])));
	}

return 0;
}

#endif
